/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:
 *------------------------------------------------------------------------------*/


#define NUM_PEAKS                   200
#define STR_DLG_NAME                "GridExample"


enum{
	 COL_NAME            =0,
	 COL_COMPUTE,
	 COL_AREA,
	
	 COL_TOTAL
    };
    
    
// an example grid with multiple columns 
class MyColumnList : public GridListControl
{
public:
	void Init(int nID, Dialog& dlg,LPCSTR lpcszDlgName)
	{		
		GridListControl::Init(nID, dlg);
		SetCols(COL_TOTAL);
		SetRows(NUM_PEAKS);
		
		SetColHeader();		
		FillGrid();		//Set the column's properties
		
		SetEditable(flexEDKbd);		//set the column can be edited
		SetSelection( flexSelectionFree );		//set the selection mode
	}
	
	void BeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel)
	{
		if( pCancel )
			*pCancel = (nCol != COL_COMPUTE);
	}
	
	void FillGrid()
	{
		vector<string> vsPeakNames;
		vsPeakNames.SetSize(NUM_PEAKS);
		for(int ii=0;ii<vsPeakNames.GetSize();ii++)
			vsPeakNames[ii]="Peak"+(string)(ii+1);
		SetCells(vsPeakNames, COL_NAME);
		
		vector<string> vsChks;
		vsChks.SetSize(vsPeakNames.GetSize());
		SetCells(vsChks, COL_COMPUTE);
		
	}
	void SetColHeader()
	{
		SetColHeading(COL_NAME,"Name");
		SetColDataType(COL_COMPUTE,flexDTBoolean);//set the column type to check box
		SetColHeading(COL_COMPUTE,"Compute");
		SetColHeading(COL_AREA,"Aear");
	}
	
	void AfterEdit(Control flxControl, int nRow, int nCol)
	{
		if(nCol!=COL_COMPUTE)
			return;
		
		bool bCheck=GetCheck(nRow, nCol);
		if(bCheck)
		{
			SetCheck(nRow, COL_COMPUTE, true);
			SetCell(nRow, COL_AREA, rand()); //set the COL_AREA column random number
		}
	}
};
 
class GridDLG : public ResizeDialog
{
public:
	GridDLG() : ResizeDialog(IDD_GRID_DLG, "GridDLG")
	{
	}

	int DoModal(HWND hParent = NULL)
	{
		InitMsgMap();// will be called from internal later
		int nRet = ResizeDialog::DoModal(hParent);
		return nRet;
	}

protected:
///----------------- Message Map ----------------
	EVENTS_BEGIN
		ON_INIT(OnInitDialog)
		ON_OK(OnOK)
		ON_CANCEL(OnCancel)
		ON_GRID_BEFORE_EDIT(IDC_GRID, OnBeforeEditColList)
        ON_GRID_AFTER_EDIT(IDC_GRID, OnAfterEditColList)
		ON_SIZE(OnDlgResize)
		ON_GETMINMAXINFO(OnMinMaxInfo)
	EVENTS_END
///----------------------------------------------
	
	BOOL OnInitDialog()
	{
		ResizeDialog::OnInitDialog(0, "Grid Dialog");
		m_ColList.Init(IDC_GRID, *this, STR_DLG_NAME);
		
		SetInitReady();
		return TRUE;
	}	

	
	BOOL OnOK()
	{
		return TRUE;
	}
	
	BOOL OnCancel()
	{
		return TRUE;
	}
	
    void OnBeforeEditColList(Control flxControl, long nRow, long nCol, BOOL* pCancel)
    {   
		m_ColList.BeforeEdit(flxControl, nRow, nCol, pCancel);
    }
    
	void OnAfterEditColList(Control flxControl,int nRow,int nCol)
	{   
		m_ColList.AfterEdit(flxControl,nRow,nCol);
	}	
	
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		if(!IsInitReady())
			return TRUE;		
		
		resizeControls(cx, cy);
		return TRUE;
		
	}
	
private:
	void resizeControls(int cx, int cy)
	{
		int nEdge = GetControlGap();
		
		// Move OK button to the right-bottom of dialog
		Button btnOK = GetItem(IDOK);
		RECT rrOK;
		GetClientRect(btnOK, rrOK);
		
		int	nHeight = RECT_HEIGHT(rrOK);
		int nWeight = RECT_WIDTH(rrOK);
		rrOK.right = cx - nEdge;
		rrOK.bottom = cy - nEdge;	
		rrOK.left = rrOK.right - nWeight;
		rrOK.top = rrOK.bottom - nHeight;
		MoveControl(btnOK, rrOK);	
		
		// Resize list control
		RECT rrList;
		rrList.bottom = rrOK.top - nEdge;		
		rrList.top = nEdge;
		rrList.left = nEdge;
		rrList.right = cx - nEdge;
		m_ColList.MoveWindow(rrList);
	}
	
private:
	MyColumnList         m_ColList;
};
